# Rule 1.3 There shall be no occurrence of undefined or critical unspecified behaviour

## Category

Required

## Analysis

Undecidable, System

## Applies to

C90, C99, C11

## Amplification

Some undefined and unspecified behaviours are dealt with by specific rules. This rule prevents all other undefined and critical unspecified behaviours. Appendix H lists the undefined behaviours and those unspecified behaviours that are considered critical.

## Rationale

Any program that gives rise to undefined or unspecified behaviour may not behave in the expected manner. In many cases, the effect is to make the program non-portable but it is also possible for more serious problems to occur. For example, undefined behaviour might affect the result of a computation. If correct operation of the software is dependent on this computation then system safety might be compromised. The problem is particularly difficult to detect if the undefined behaviour only manifests itself on rare occasions.

Many of the MISRA C guidelines have been designed to avoid certain undefined and unspecified behaviours. However, other behaviours are not covered by specific guidelines, for example because:
* It is unlikely that the behaviour will be encountered;
* There is no practical guidance that can be given other than the obvious statement that the behaviour should be avoided.

Instead of introducing a guideline for each undefined and critical unspecified behaviour, the MISRA C Guidelines directly address those that are considered most important and most likely to occur in practice. Those behaviours that do not have specific guidelines are all covered together by this single rule.

Appendix H lists all undefined and critical unspecified behaviours, along with the MISRA C guidelines that prevent their occurrence. It therefore indicates which behaviours are expected to be prevented by this rule and which behaviours are covered by other rules.

Note: some implementations may provide well-defined behaviour for some of the undefined and unspecified behaviours listed in the C Standard. If such well-defined behaviours are relied upon, including by means of a language extension, it will be necessary to deviate this rule in respect of those behaviours. 

## See also

Dir 4.1

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
