# Rule 7.5 The argument of an integer constant macro shall have an appropriate form

## Category

Mandatory

## Analysis

Decidable, Single Translation Unit

## Applies to

C99, C11

## Amplification

The argument of an integer constant macro shall satisfy the following:
* The argument must be an unsuffixed integer (decimal, octal or hexadecimal) literal;
* The value of the argument must not exceed the limits for the equivalent exact-width type indicated by the name of the macro used. For example, the argument to `UINT16_C` must be representable as an unsigned 16-bit value. 

## Rationale

The behaviour is undefined if the argument of an integer constant macro does not have an appropriate form.

## Example

```c
#include <stdint.h>

uint32_t u1 = UINT32_C(10); /* Compliant */
uint32_t u2 = UINT32_C(10UL); /* Non-compliant - constant is suffixed */
uint32_t u3 = UINT32_C(10.0); /* Non-compliant - floating-point constant */
uint16_t u4 = UINT16_C(-2); /* Non-compliant - constant expression */

int32_t s1 = INT32_C(-2); /* Compliant */
int32_t s2 = INT32_C(2); /* Compliant */

```

In the following example, the constant has a value that cannot be represented in 16 bits.

```c
uint_least16_t u5 = UINT16_C(0x10000); /* Non-compliant, even if uint_least16_t is implemented as a 32-bit type */

```

## See also

Rule 7.6

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
