# Rule 9.6 An initializer using chained designators shall not contain initializers without designators

## Category

Required

## Analysis

Decidable, Single Translation Unit

## Applies to

C99, C11

## Amplification

A chained designator is a designator list that has more than one item, thus specifying an element of a sub-object within the current object.

If an aggregate initializer uses designators to specify elements, and any designator in the initializer is chained, every initializer in the entire containing initializer list shall specify an element explicitly using a designator.

This rule applies to initializers for both objects and sub-objects. 

## Rationale

Using chained designators for selective sub-object designation can make the intent of the initializer clear for some constructs such as sparse matrices. However, combining chained designators with positional initialization is extremely unclear — a human reader cannot easily tell whether the intended next object is within the sub-object, or within the same object level from which the designator started lookup. The syntactic brace structure of the initializer list may also no longer match the depth of the selected element, adding to the confusion. 

## Exception

A braced sub-object initializer may omit designators to specify elements if it does not contain any chained designators, and no chained designators in the containing initializer list specify an element inside it as the current object. 

## Example

```c
struct S
{
    int x;
    int y;
};
struct T
{
    int w;
    struct S s;
    int z;
};

/* Non-compliant - chained designators and implicit positional initializers mixed */
struct T tt = {
    1,
    .s.x = 2, /* To a human reader, this looks like .z is being initialized */
    3, /* tt is actually initialized as { 1, { 2, 3 }, 0 } */
};
/* This also violates Rule 9.2 */

/* Compliant - allow the y dimension to implicitly initialize to zero */
struct S aa[5] = {
    [0].x = 1,
    [1].x = 2,
    [2].x = 3,
    [3].x = 4,
    [4].x = 5,
};

/* Compliant - the initializer for [1] is not chained, but is explicit */
struct S ab[2] = {
    [0].x = 1,
    [1] = { 2, 3 }, /* Compliant by exception: the positional initializers are inside a braced sub-object */
};

```

## See also

Rule 9.2, Rule 9.4

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
