# Rule 0–1–7 (Required) The value returned by a function having a non-void return type that is not an overloaded operator shall always be used.

## Rationale
In C++ it is possible to call a function without using the return value, which may be an error. The return value of a function shall always be used.
Overloaded operators are excluded, as they should behave in the same way as built-in operators.

## Exception
The return value of a function may be discarded by use of a (void) cast.

## Example
```c
uint16_t func ( uint16_t para1 ) 
{ 
 return para1; 
}
void discarded ( uint16_t para2 ) 
{ 
 func ( para2 ); // value discarded – Non-compliant 
 (void)func ( para2 ); // Compliant 
}
```

## See also
Rule 5–2–4

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
