# Rule 16–3–1 (Required) There shall be at most one occurrence of the # or ## operators in a single macro definition.

## Amplification
[Unspecified 16.3.2(2), 16.3.3(3), Undefined 16.3.2(2), 16.3.3(3)]

## Rationale
The order of evaluation associated with both the # and ## preprocessor operators is unspecified. This problem can be avoided by having only one occurrence of either operator in any single macro definition (i.e. one #, or one ## or neither).

## Example
```c
#define A(x) #x // Compliant 
#define B(x, y) x ## y // Compliant 
#define C(x, y) # x ## y // Non-compliant
```
In the following, if y is joined to z first then the fourth parameter of D will be substituted and joined to x. Alternatively, if x is joined with y first, then the fourth parameter of D will not be substituted.
```c
#define D(x, y, z, yz) x ## y ## z // Non-compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
