# Rule 4–10–2 (Required) Literal zero (0) shall not be used as the null-pointer-constant.

## Rationale
In C++, the literal 0 is both an integer type and the null-pointer-constant. To meet developer expectations, NULL should be used as the null-pointer-constant, and 0 for the integer zero.

## Example
```c
#include <cstddef>
void f1 ( int32_t ); 
void f2 ( int32_t * );
void f3 ( ) 
{ 
 f1 ( 0 ); // Compliant 
 f2 ( 0 ); // Non-compliant, 0 used as the null pointer constant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
