# Rule 6–2–2 (Required) Floating-point expressions shall not be directly or indirectly tested for equality or inequality.

## Rationale
The inherent nature of floating-point types is such that comparisons of equality will often not evaluate to true, even when they are expected to. Also, the behaviour of such a comparison cannot be predicted before execution, and may well vary from one implementation to another.
The recommended method for achieving deterministic floating-point comparisons is to write a library that implements the comparison operations. The library should take into account the floating-point granularity (std::numeric_limits<float>::epsilon()) and the magnitude of the numbers being compared.

## Example
The result of the test in the following code is unpredictable:
```c
float32_t x, y;
if ( x == y ) // Non-compliant 
if ( x == 0.0f ) // Non-compliant
```
An indirect test is equally problematic and is also prohibited by this rule:
```c
if ( ( x <= y ) && ( x >= y ) ) // Non-compliant
if ( ( x < y ) || ( x > y ) ) // Non-compliant
```
The following is better, but only if the magnitudes are appropriate:
```c
if ( fabs ( x – y ) <= 
 std::numeric_limits<float>::epsilon( ) ) // Compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
