# Rule 7–4–3 (Required) Assembly language shall be encapsulated and isolated.

## Rationale
Ensuring that assembly language code is encapsulated and isolated aids portability.
Where assembly language instructions are needed, they shall be encapsulated and isolated in either assembler functions or C++ functions.

## Example
```c
void Delay ( void ) 
{ 
 asm ( "NOP" ); // Compliant 
}
void fn ( void ) 
{ 
 DoSomething ( ); 
 Delay ( ); // Assembler is encapsulated 
 DoSomething ( ); 
 asm ( "NOP" ); // Non-compliant 
 DoSomething ( ); 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
