# Rule 9–6–2 (Required) Bit-fields shall be either bool type or an explicitly unsigned or signed integral type.

## Amplification
[Implementation 3.9.1(5), 7.1.5.2(1), 9.6(3)]

## Rationale
Using int is implementation-defined because bit-fields of type int can be either signed or unsigned.
The use of wchar_t as a bit-field type is prohibited as ISO/IEC 14882:2003 [1] does not explicitly define the underlying representation as signed or unsigned.

## Example
```c
struct S 
{ 
 signed int a : 2; // Compliant 
 unsigned int b : 2; // Compliant 
 char c : 2; // Non-compliant 
 signed char d : 2; // Compliant 
 unsigned char e : 2; // Compliant 
 short f : 2; // Non-compliant 
 signed short g : 2; // Compliant 
 unsigned short h : 2; // Compliant 
 int i : 2; // Non-compliant 
 bool j : 2; // Compliant 
 wchar_t k : 2; // Non-compliant 
 uint32_t l : 2; // Compliant 
 int8_t m : 2; // Compliant 
};
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
