# Rule 6.7.1 Local variables shall not have static storage duration

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule does not apply to variables declared `constexpr` or `const`.

## Rationale
The use of mutable variables with static storage duration, even when they do not have linkage,
potentially results in hidden temporal coupling. This can lead to data races (and thus *undefined
behaviour*). Additionally, functions with persistent state are usually more difficult to understand and
test.

Note: the lifetime of local variables with static storage duration ends at program termination in the
reverse order of their creation. Suitable care should be taken to ensure that the code executed during
destruction does not access a previously destroyed variable.

## Example
```cpp
int32_t bar();

int32_t ga = 0; // Compliant - but violates "See also"

int32_t foo()
{
  int32_t a = 0; // Compliant
  static int32_t b = 0; // Non-compliant
  static constexpr int32_t c = 0; // Compliant
  static const int32_t d = bar(); // Compliant
}

class Application
{
  static Application & theApp()
  {
    static Application app; // Non-compliant
    return app;
  }
};
```

## See also
Rule 6.7.2

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
