# Rule 8.2.8 An object pointer type shall not be cast to an integral type other than `std::uintptr_t` or `std::intptr_t`

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
The *type-id* used in the *cast-expression* shall explicitly specify `std::uintptr_t` or `std::intptr_t`.

## Rationale
The types `std::uintptr_t` and `std::intptr_t` are the only types that are guaranteed to be able
to represent all possible values of an object pointer type.

Note: these types are optional and may not be available in all implementations, in which case a
deviation will need to be raised against this rule.

## Example
```cpp
struct S;

void f1( S * s )
{
  auto p0 = reinterpret_cast< std::uintptr_t >( s ); // Compliant

  auto p1 = reinterpret_cast< unsigned long >( s ); // Non-compliant

  using hashPtr_t = std::uintptr_t;
  auto p2 = reinterpret_cast< hashPtr_t >( s ); // Non-compliant
}

template< typename T > void f2( S * s )
{
  auto p = reinterpret_cast< T >( s ); // Non-compliant - T is not explicitly
} // std::uintptr_t

template void f2< std::uintptr_t >( S * s );
```

## See also
Rule 8.2.5, Rule 8.2.7

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
