Ensures that classes use contextual decorators in its body

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Injectable({
  providedIn: 'root'
})
class Test {
  @Input()
  ~~~~~~~~
  get label(): string {
    return this._label;
  }
  set label(value: string) {
    this._label = value;
  }
  private _label: string;
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable({
  providedIn: 'root'
})
class Test {
  @Input()
  ~~~~~~~~
  set label(value: string) {
    this._label = value;
  }
  get label(): string {
    return this._label;
  }
  private _label: string;
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable({
  providedIn: 'root'
})
class Test {
  @ViewChild(Pane)
  ~~~~~~~~~~~~~~~~
  set label(value: Pane) {
    doSomething();
  }
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable({
  providedIn: 'root'
})
class Test {
  @HostListener('mouseover')
  ~~~~~~~~~~~~~~~~~~~~~~~~~~
  mouseOver() {
    this.doSomething();
  }
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable({
  providedIn: 'root'
})
class Test {
  constructor(
    @Attribute('test') private readonly test: string
    ~~~~~~~~~~~~~~~~~~
  ) {}
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable({
  providedIn: 'root'
})
class Test {
  @ContentChild(Pane) pane: Pane;
  ~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable({
  providedIn: 'root'
})
class Test {
  @ContentChildren(Pane, { descendants: true }) arbitraryNestedPanes: QueryList<Pane>;
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable({
  providedIn: 'root'
})
class Test {
  @HostBinding('class.card-outline') private isCardOutline: boolean;
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule({
  providers: []
})
class Test {
  @Input() label: string;
  ~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule({
  providers: []
})
class Test {
  @Output() emitter = new EventEmitter<void>();
  ~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule({
  providers: []
})
class Test {
  @ViewChild(Pane) pane: Pane;
  ~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule({
  providers: []
})
class Test {
  @ViewChildren(Pane) panes: QueryList<Pane>;
  ~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule({
  providers: []
})
class Test {
  @ContentChild(Pane) pane: Pane;
  ~~~~~~~~~~~~~~~~~~~

  @Input()
  ~~~~~~~~
  get label(): string {
    return this._label;
  }
  set label(value: string) {
    this._label = value;
  }
  private _label: string;

  @ViewChild(Pane)
  ~~~~~~~~~~~~~~~~
  set label(value: Pane) {
    doSomething();
  }

  get type(): string {
    return this._type;
  }
  set type(value: string) {
    this._type = value;
  }
  private _type: string;

  private prop: string | undefined;

  constructor(
    @Attribute('test') private readonly test: string,
    ~~~~~~~~~~~~~~~~~~
    @Inject(LOCALE_ID) localeId: string
  ) {}

  @HostListener('mouseover')
  ~~~~~~~~~~~~~~~~~~~~~~~~~~
  mouseOver() {
    this.doSomething();
  }

  clickHandler(): void {}
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  @Input()
  ~~~~~~~~
  get label(): string {
    return this._label;
  }
  set label(value: string) {
    this._label = value;
  }
  private _label: string;
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  @Input()
  ~~~~~~~~
  set label(value: string) {
    this._label = value;
  }
  get label(): string {
    return this._label;
  }
  private _label: string;
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  @ViewChild(Pane)
  ~~~~~~~~~~~~~~~~
  set label(value: Pane) {
    doSomething();
  }
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  @HostListener('mouseover')
  ~~~~~~~~~~~~~~~~~~~~~~~~~~
  mouseOver() {
    this.doSomething();
  }
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  constructor(
    @Attribute('test') private readonly test: string
    ~~~~~~~~~~~~~~~~~~
  ) {}
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  @ContentChild(Pane) pane: Pane;
  ~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  @ContentChildren(Pane, { descendants: true }) arbitraryNestedPanes: QueryList<Pane>;
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  @HostBinding('class.card-outline') private isCardOutline: boolean;
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  @Input() label: string;
  ~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  @Output() emitter = new EventEmitter<void>();
  ~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  @ViewChild(Pane) pane: Pane;
  ~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  @ViewChildren(Pane) panes: QueryList<Pane>;
  ~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  @ContentChild(Pane) pane: Pane;
  ~~~~~~~~~~~~~~~~~~~

  @Input()
  ~~~~~~~~
  get label(): string {
    return this._label;
  }
  set label(value: string) {
    this._label = value;
  }
  private _label: string;

  @ViewChild(Pane)
  ~~~~~~~~~~~~~~~~
  set label(value: Pane) {
    doSomething();
  }

  get type(): string {
    return this._type;
  }
  set type(value: string) {
    this._type = value;
  }
  private _type: string;

  private prop: string | undefined;

  constructor(
    @Attribute('test') private readonly test: string,
    ~~~~~~~~~~~~~~~~~~
    @Inject(LOCALE_ID) localeId: string
  ) {}

  @HostListener('mouseover')
  ~~~~~~~~~~~~~~~~~~~~~~~~~~
  mouseOver() {
    this.doSomething();
  }

  clickHandler(): void {}
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  selector: 'test'
})
class TestDirective {
  @Input() label: string;
}

@Pipe({
  name: 'test'
})
class Test {
  @Input() label: string;
  ~~~~~~~~
}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  @Input()
  get label(): string {
    return this._label;
  }
  set label(value: string) {
    this._label = value;
  }
  private _label: string;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  @Input()
  set label(value: string) {
    this._label = value;
  }
  get label(): string {
    return this._label;
  }
  private _label: string;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  @ViewChild(Pane)
  set label(value: Pane) {
    doSomething();
  }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  @HostListener('mouseover')
  mouseOver() {
    this.doSomething();
  }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  constructor(
    @Host() private readonly host: DynamicHost
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  constructor(
    @Inject(LOCALE_ID) private readonly localeId: string
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  constructor(
    @Optional() testBase: TestBase,
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  constructor(
    @Self() public readonly test: Test,
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  constructor(
    @SkipSelf() protected readonly parentTest: ParentTest
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  @ContentChild(Pane) pane: Pane;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  @ContentChildren(Pane, { descendants: true }) arbitraryNestedPanes: QueryList<Pane>;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  @HostBinding('class.card-outline') private isCardOutline: boolean;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  @Input() label: string;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  @Output() emitter = new EventEmitter<void>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  @ViewChild(Pane)
  set pane(value: Pane) {
    console.log('panel setter called');
  }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  @ViewChildren(Pane) panes: QueryList<Pane>;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  template: 'Hi!'
})
class Test {
  @ContentChild(Pane) pane: Pane;

  @Input()
  get label(): string {
    return this._label;
  }
  set label(value: string) {
    this._label = value;
  }
  private _label: string;

  @ViewChild(Pane)
  set label(value: Pane) {
    doSomething();
  }

  get type(): string {
    return this._type;
  }
  set type(value: string) {
    this._type = value;
  }
  private _type: string;

  private prop: string | undefined;

  constructor(
    @Attribute('test') private readonly test: string,
    @Host() @Optional() private readonly host: DynamicHost,
    @Inject(LOCALE_ID) private readonly localeId: string,
    @Inject(TEST_BASE) @Optional() testBase: TestBase,
    @Optional() @Self() public readonly test: Test,
    @Optional() @SkipSelf() protected readonly parentTest: ParentTest
  ) {}

  @HostListener('mouseover')
  mouseOver(): void {
    this.doSomething();
  }

  clickHandler(): void {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  @Input()
  get label(): string {
    return this._label;
  }
  set label(value: string) {
    this._label = value;
  }
  private _label: string;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  @Input()
  set label(value: string) {
    this._label = value;
  }
  get label(): string {
    return this._label;
  }
  private _label: string;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  @ViewChild(Pane)
  set label(value: Pane) {
    doSomething();
  }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  @HostListener('mouseover')
  mouseOver() {
    this.doSomething();
  }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  constructor(
    @Host() private readonly host: DynamicHost
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  constructor(
    @Inject(LOCALE_ID) private readonly localeId: string
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  constructor(
    @Optional() testBase: TestBase,
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  constructor(
    @Self() public readonly test: Test,
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  constructor(
    @SkipSelf() protected readonly parentTest: ParentTest
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  @ContentChild(Pane) pane: Pane;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  @ContentChildren(Pane, { descendants: true }) arbitraryNestedPanes: QueryList<Pane>;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  @HostBinding('class.card-outline') private isCardOutline: boolean;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  @Input() label: string;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  @Output() emitter = new EventEmitter<void>();
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  @ViewChild(Pane)
  set pane(value: Pane) {
    console.log('panel setter called');
  }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  @ViewChildren(Pane) panes: QueryList<Pane>;
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'test'
})
class Test {
  @ContentChild(Pane) pane: Pane;

  @Input()
  get label(): string {
    return this._label;
  }
  set label(value: string) {
    this._label = value;
  }
  private _label: string;

  @ViewChild(Pane)
  set label(value: Pane) {
    doSomething();
  }

  get type(): string {
    return this._type;
  }
  set type(value: string) {
    this._type = value;
  }
  private _type: string;

  private prop: string | undefined;

  constructor(
    @Attribute('test') private readonly test: string,
    @Host() @Optional() private readonly host: DynamicHost,
    @Inject(LOCALE_ID) private readonly localeId: string,
    @Inject(TEST_BASE) @Optional() testBase: TestBase,
    @Optional() @Self() public readonly test: Test,
    @Optional() @SkipSelf() protected readonly parentTest: ParentTest
  ) {}

  @HostListener('mouseover')
  mouseOver(): void {
    this.doSomething();
  }

  clickHandler(): void {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable({
  providedIn: 'root'
})
class Test {
  constructor(
    @Host() private readonly host: DynamicHost
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable({
  providedIn: 'root'
})
class Test {
  constructor(
    @Inject(LOCALE_ID) private readonly localeId: string
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable({
  providedIn: 'root'
})
class Test {
  constructor(
    @Optional() testBase: TestBase,
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable({
  providedIn: 'root'
})
class Test {
  constructor(
    @Self() public readonly test: Test,
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable({
  providedIn: 'root'
})
class Test {
  constructor(
    @SkipSelf() protected readonly parentTest: ParentTest
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable({
  providedIn: 'root'
})
class Test {
  get type(): string {
    return this._type;
  }
  set type(value: string) {
    this._type = value;
  }
  private _type: string;

  private prop: string | undefined;

  constructor(
    @Host() @Optional() private readonly host: DynamicHost,
    @Inject(LOCALE_ID) private readonly localeId: string,
    @Inject(TEST_BASE) @Optional() testBase: TestBase,
    @Optional() @Self() public readonly test: Test,
    @Optional() @SkipSelf() protected readonly parentTest: ParentTest
  ) {}

  clickHandler(): void {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule({
  providers: []
})
class Test {
  constructor(
    @Host() private readonly host: DynamicHost
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule({
  providers: []
})
class Test {
  constructor(
    @Inject(LOCALE_ID) private readonly localeId: string
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule({
  providers: []
})
class Test {
  constructor(
    @Optional() testBase: TestBase,
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule({
  providers: []
})
class Test {
  constructor(
    @Self() public readonly test: Test,
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule({
  providers: []
})
class Test {
  constructor(
    @SkipSelf() protected readonly parentTest: ParentTest
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule({
  providers: []
})
class Test {
  get type(): string {
    return this._type;
  }
  set type(value: string) {
    this._type = value;
  }
  private _type: string;

  private prop: string | undefined;

  constructor(
    @Host() @Optional() private readonly host: DynamicHost,
    @Inject(LOCALE_ID) private readonly localeId: string,
    @Inject(TEST_BASE) @Optional() testBase: TestBase,
    @Optional() @Self() public readonly test: Test,
    @Optional() @SkipSelf() protected readonly parentTest: ParentTest
  ) {}

  clickHandler(): void {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  constructor(
    @Host() private readonly host: DynamicHost
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  constructor(
    @Inject(LOCALE_ID) private readonly localeId: string
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  constructor(
    @Optional() testBase: TestBase,
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  constructor(
    @Self() public readonly test: Test,
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  constructor(
    @SkipSelf() protected readonly parentTest: ParentTest
  ) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  name: 'test'
})
class Test {
  get type(): string {
    return this._type;
  }
  set type(value: string) {
    this._type = value;
  }
  private _type: string;

  private prop: string | undefined;

  constructor(
    @Host() @Optional() private readonly host: DynamicHost,
    @Inject(LOCALE_ID) private readonly localeId: string,
    @Inject(TEST_BASE) @Optional() testBase: TestBase,
    @Optional() @Self() public readonly test: Test,
    @Optional() @SkipSelf() protected readonly parentTest: ParentTest
  ) {}

  clickHandler(): void {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable()
class TestService {
  constructor() {}
}

@Component({
  selector: 'app-test',
  template: '<h1>Hello</h1>',
  providers: [TestService]
})
class TestComponent implements OnChanges {
  @Output() emitter = new EventEmitter<void>();

  constructor(private test: TestService) {}
}
```

</details>
