Classes decorated with @Directive must have suffix "Directive" (or custom) in their name. See more at https://angular.io/styleguide#style-02-03

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Directive({
  selector: 'sg-foo-bar'
})
class Test {}
      ~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  selector: 'sg-foo-bar'
})
class TestDirectivePage implements AsyncValidator {}
      ~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  selector: 'sgBarFoo'
})
class TestPageDirective {}
      ~~~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'sgBarFoo'
})
class TestDirective {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'sgBarFoo'
})
class TestValidator implements Validator {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'sgBarFoo'
})
class TestValidator implements AsyncValidator {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'sg-bar-foo'
})
class TestComponent {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({
  name: 'sgPipe'
})
class TestPipe {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable()
class TestService {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class TestEmpty {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'sgBarFoo'
})
class TestDir {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'sgBarFoo'
})
class TestPage {}
```

</details>
