Disallows calling expressions in templates, except for output handlers

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<div>{{ getInfo()() }}</div>
        ~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<a href="{{ getUrls().user }}"></a>
            ~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<p [test]="test?.getInfo()"></p>
           ~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<a [href]="id && createUrl() && test()($any)">info</a>
                 ~~~~~~~~~~~    ~~~~~~~~~~~~
{{ id || obj?.nested1() }}
         ~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<a [href]="id ? a?.createUrl() : editUrl(3)">info</a>
                ~~~~~~~~~~~~~~   ~~~~~~~~~~
{{ 1 === 2 ? 3 : obj?.nested1()() }}
                 ~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
{{ obj?.nested1() }} {{ obj!.nested1() }}
   ~~~~~~~~~~~~~~       ~~~~~~~~~~~~~~
<button [type]="obj!.$any(b)!.getType()()">info</button>
                ~~~~~~~~~~~~~~~~~~~~~~~~~
<a [href]="obj.propertyA?.href()">info</a>
           ~~~~~~~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
{{ info }}
```

<br>

---

<br>

#### ✅ Valid Code

```html
<button type="button" (click)="handleClick()">Click Here</button>
```

<br>

---

<br>

#### ✅ Valid Code

```html
{{ $any(info) }}
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input (change)="obj?.changeHandler()">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<form [formGroup]="form" (ngSubmit)="form.valid || save()"></form>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<form [formGroup]="form" (ngSubmit)="form.valid && save()"></form>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<form [formGroup]="form" (ngSubmit)="id ? save() : edit()"></form>
```

<br>

---

<br>

#### ✅ Valid Code

```html
{{ obj?.nested() }} {{ obj!.nested() }}
<a [href]="getHref()">info</a>
```

</details>
