### SCS0024 - View State MAC Disabled 

The `enableViewStateMac` is disabled in configuration file. (This feature cannot be disabled starting .NET 4.5.1)

#### Risk

The view state could be altered by an attacker.

#### Vulnerable Code

```xml
<system.web>
   ...
   <pages [..] enableViewStateMac="false" [..]/>
   ...
</system.web>

```

#### Solution

The default value is secure - `true`. Or set it explicitly:

```xml
<system.web>
   ...
   <pages [..] enableViewStateMac="true" [..]/>
   ...
</system.web>

```

#### References

[CWE-554: ASP.NET Misconfiguration: Not Using Input Validation Framework](https://cwe.mitre.org/data/definitions/554.html)  
[MSDN: pages Element (ASP.NET Settings Schema)](https://msdn.microsoft.com/en-us/library/950xf363%28v=vs.100%29.aspx)

## Request Validation

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)