<h2>Why is this an issue?</h2>
<p>In single-threaded environments, the use of <code>this</code> in constructors is normal, and expected. But in multi-threaded environments, it could
expose partially-constructed objects to other threads, and should be used with caution.</p>
<p>The classic example is a class with a <code>static</code> list of its instances. If the constructor stores <code>this</code> in the list, another
thread could access the object before it’s fully-formed. Even when the storage of <code>this</code> is the last instruction in the constructor,
there’s still a danger if the class is not <code>final</code>. In that case, the initialization of subclasses won’t be complete before
<code>this</code> is exposed.</p>
<p>This rule raises an issue when <code>this</code> is assigned to any globally-visible object in a constructor, and when it is passed to the method
of another object in a constructor</p>
<h3>Noncompliant code example</h3>
<pre>
public class Monument
{
  public static readonly List&lt;Monument&gt; ALL_MONUMENTS = new List&lt;Monument&gt;();
  // ...

  public Monument(string location, ...)
  {
    ALL_MONUMENTS.Add(this);  // Noncompliant; passed to a method of another object

    this.location = location;
    // ...
  }
}
</pre>
<h3>Exceptions</h3>
<p>This rule ignores instances of assigning <code>this</code> directly to a <code>static</code> field of the same class because that case is covered
by {rule:csharpsquid:S3010} .</p>

