<h2>Why is this an issue?</h2>
<p>The size of a collection and the length of an array are always greater than or equal to zero. Testing it doesn’t make sense, since the result is
always <code>true</code>.</p>
<pre>
if(collection.Count &gt;= 0){...} // Noncompliant: always true

if(array.Length &gt;= 0){...} // Noncompliant: always true
</pre>
<p>Similarly testing that it is less than zero will always return <code>false</code>.</p>
<pre>
if(enumerable.Count() &lt; 0){...} // Noncompliant: always false
</pre>
<p>Fix the code to properly check for emptiness if it was the intent, or remove the redundant code to keep the current behavior.</p>

