<h2>Why is this an issue?</h2>
<p>When a reference parameter (keyword <code>ref</code>) is used, the passed argument type must exactly match the reference parameter type. This means
that to be able to pass a derived type, it must be cast and assigned to a variable of the proper type. Use of generic methods eliminates that
cumbersome down casting and should therefore be preferred.</p>
<p>This rule raises an issue when a method contains a <code>ref</code> parameter of type <code>System.Object</code>.</p>
<h3>Noncompliant code example</h3>
<pre>
using System;

namespace MyLibrary
{
  public class Foo
  {
    public void Bar(ref object o1, ref object o2) // Noncompliant
    {
    }
  }
}
</pre>
<h3>Compliant solution</h3>
<pre>
using System;

namespace MyLibrary
{
  public class Foo
  {
    public void Bar&lt;T&gt;(ref T ref1, ref T ref2)
    {
    }
  }
}
</pre>

