﻿## SA1122

<table>
<tr>
  <td>TypeName</td>
  <td>SA1122UseStringEmptyForEmptyStrings</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1122</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

The C# code includes an empty string, written as `""`.

## Rule description

A violation of this rule occurs when the code contains an empty string. For example:

```csharp
string s = "";
```

This will cause the compiler to embed an empty string into the compiled code. Rather than including a hard-coded empty string, use the static string.Empty property:

```csharp
string s = string.Empty;
```

## How to fix violations

To fix a violation of this rule, replace the hard-coded empty string with string.Empty.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1122:UseStringEmptyForEmptyStrings", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1122 // UseStringEmptyForEmptyStrings
#pragma warning restore SA1122 // UseStringEmptyForEmptyStrings
```
