## SA1128

<table>
<tr>
  <td>TypeName</td>
  <td>SA1128ConstructorInitializerMustBeOnOwnLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1128</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

A constructor initializer is on the same line as the constructor declaration, within a C# code file.

## Rule description

A violation of this rule occurs whenever the code contains a constructor initializer that is partially or completely on the same line as the constructor declaration.

For example, the following code would produce a violation of this rule:

```csharp
public class TypeName
{
    public TypeName() : this(0)
    {
    }

    public TypeName(int value)
    {
    }
}
```

The `:` (colon) character is treated as part of the initializer and should be on the same line as the `base` or `this` keyword.

The following code would also produce a violation of this rule:

```csharp
public class TypeName
{
	public TypeName() :
		base()
	{
	}
}
```

The following code would not produce any violations:

```csharp
public class TypeName
{
    public TypeName()
        : this(0)
    {
    }

    public TypeName(int value)
    {
    }
}
```

## How to fix violations

To fix a violation of this rule, move the constructor initializer, including the `:` character, to its own line.

## How to suppress violations

```csharp
public class TypeName
{
#pragma warning disable SA1128 // Constructor initializers should be on their own line
    public TypeName() : this(0)
#pragma warning restore SA1128 // Constructor initializers should be on their own line
    {
    }

    public TypeName(int value)
    {
    }
}
```
