﻿## SA1643

<table>
<tr>
  <td>TypeName</td>
  <td>SA1643DestructorSummaryDocumentationMustBeginWithStandardText</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1643</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The Xml documentation header for a C# finalizer does not contain the appropriate summary text.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs when the summary tag within the documentation header for a finalizer does not begin with the proper text.

The rule is intended to standardize the summary text for a finalizer. The summary for a finalizer should begin with "Finalizes an instance of the {class name} class." For example, the following shows the finalizer for the Customer class.

```csharp
/// <summary>
/// Finalizes an instance of the Customer class.
/// </summary>
~Customer()
{
}
```

It is possible to embed other tags into the summary text. For example:

```csharp
/// <summary>
/// Finalizes an instance of the <see cref="Customer"/> class.
/// </summary>
~Customer()
{
}
```

## How to fix violations

To fix a violation of this rule, edit the summary text for the finalizer as described above.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1643:DestructorSummaryDocumentationMustBeginWithStandardText", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1643 // DestructorSummaryDocumentationMustBeginWithStandardText
#pragma warning restore SA1643 // DestructorSummaryDocumentationMustBeginWithStandardText
```
