<p>Local variables and method parameters should be named consistently to communicate intent and improve maintainability. Rename your local variable or
method parameter to follow your project’s naming convention to address this issue.</p>
<h2>Why is this an issue?</h2>
<p>A naming convention in software development is a set of guidelines for naming code elements like variables, functions, and classes.<br> Local
variables and method parameters hold the meaning of the written code. Their names should be meaningful and follow a consistent and easily recognizable
pattern.<br> Adhering to a consistent naming convention helps to make the code more readable and understandable, which makes it easier to maintain and
debug. It also ensures consistency in the code, especially when multiple developers are working on the same project.</p>
<p>This rule checks that local variable and method parameter names match a provided regular expression.</p>
<h3>What is the potential impact?</h3>
<p>Inconsistent naming of local variables and method parameters can lead to several issues in your code:</p>
<ul>
  <li> <strong>Reduced Readability</strong>: Inconsistent local variable and method parameter names make the code harder to read and understand;
  consequently, it is more difficult to identify the purpose of each variable, spot errors, or comprehend the logic. </li>
  <li> <strong>Difficulty in Identifying Variables</strong>: The local variables and method parameters that don’t adhere to a standard naming
  convention are challenging to identify; thus, the coding process slows down, especially when dealing with a large codebase. </li>
  <li> <strong>Increased Risk of Errors</strong>: Inconsistent or unclear local variable and method parameter names lead to misunderstandings about
  what the variable represents. This ambiguity leads to incorrect assumptions and, consequently, bugs in the code. </li>
  <li> <strong>Collaboration Difficulties</strong>: In a team setting, inconsistent naming conventions lead to confusion and miscommunication among
  team members. </li>
  <li> <strong>Difficulty in Code Maintenance</strong>: Inconsistent naming leads to an inconsistent codebase. The code is difficult to understand,
  and making changes feels like refactoring constantly, as you face different naming methods. Ultimately, it makes the codebase harder to maintain.
  </li>
</ul>
<p>In summary, not adhering to a naming convention for local variables and method parameters can lead to confusion, errors, and inefficiencies, making
the code harder to read, understand, and maintain.</p>
<h3>Exceptions</h3>
<p>Loop counters are ignored by this rule.</p>

```java
for (int i_1 = 0; i_1 < limit; i_1++) {  // Compliant
  // ...
}
```
<p>as well as one-character <code>catch</code> variables:</p>

```java
try {
//...
} catch (Exception e) { // Compliant
}
```
<h2>How to fix it</h2>
<p>First, familiarize yourself with the particular naming convention of the project in question. Then, update the name to match the convention, as
well as all usages of the name. For many IDEs, you can use built-in renaming and refactoring features to update all usages at once.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<p>With the default regular expression <code>^[a-z][a-zA-Z0-9]*$</code>:</p>

```java
public class MyClass {
    public void doSomething(int myParam) {
      int LOCAL;    // Noncompliant
      // ...
    }
}
```
<h4>Compliant solution</h4>

```java
public class MyClass {
    public void doSomething(int my_param) {
      int local;
      // ...
    }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Oracle - <a href="https://www.oracle.com/java/technologies/javase/codeconventions-namingconventions.html">Java SE Naming Conventions</a> </li>
  <li> Geeksforgeeks - <a href="https://www.geeksforgeeks.org/java-naming-conventions/">Java Naming Conventions</a> </li>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Naming_convention_(programming)">Naming Convention (programming)</a> </li>
</ul>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S100'>java:S100</a> - Method names should comply with a naming convention </li>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S101'>java:S101</a> - Class names should comply with a naming convention </li>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S114'>java:S114</a> - Interface names should comply with a naming convention </li>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S115'>java:S115</a> - Constant names should comply with a naming convention </li>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S116'>java:S116</a> - Field names should comply with a naming convention </li>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S118'>java:S118</a> - Abstract class names should comply with a naming convention </li>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S119'>java:S119</a> - Type parameter names should comply with a naming convention </li>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S120'>java:S120</a> - Package names should comply with a naming convention </li>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S1312'>java:S1312</a> - Loggers should be "private static final" and should share a naming convention </li>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S3008'>java:S3008</a> - Static non-final field names should comply with a naming convention </li>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S3577'>java:S3577</a> - Test classes should comply with a naming convention </li>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S3578'>java:S3578</a> - Test methods should comply with a naming convention </li>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S4174'>java:S4174</a> - Local constants should follow naming conventions for constants </li>
</ul>