<h2>Why is this an issue?</h2>
<p>The old, much-derided <code>Date</code> and <code>Calendar</code> classes have always been confusing and difficult to use properly, particularly in
a multi-threaded context. <code>JodaTime</code> has long been a popular alternative, but now an even better option is built-in. Java 8’s JSR 310
implementation offers specific classes for:</p>
<table>
  <colgroup>
    <col style="width: 50%;">
    <col style="width: 50%;">
  </colgroup>
  <thead>
    <tr>
      <th>Class</th>
      <th>Use for</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><p>LocalDate</p></td>
      <td><p>a date, without time of day, offset, or zone</p></td>
    </tr>
    <tr>
      <td><p>LocalTime</p></td>
      <td><p>the time of day, without date, offset, or zone</p></td>
    </tr>
    <tr>
      <td><p>LocalDateTime</p></td>
      <td><p>the date and time, without offset, or zone</p></td>
    </tr>
    <tr>
      <td><p>OffsetDate</p></td>
      <td><p>a date with an offset such as +02:00, without time of day, or zone</p></td>
    </tr>
    <tr>
      <td><p>OffsetTime</p></td>
      <td><p>the time of day with an offset such as +02:00, without date, or zone</p></td>
    </tr>
    <tr>
      <td><p>OffsetDateTime</p></td>
      <td><p>the date and time with an offset such as +02:00, without a zone</p></td>
    </tr>
    <tr>
      <td><p>ZonedDateTime</p></td>
      <td><p>the date and time with a time zone and offset</p></td>
    </tr>
    <tr>
      <td><p>YearMonth</p></td>
      <td><p>a year and month</p></td>
    </tr>
    <tr>
      <td><p>MonthDay</p></td>
      <td><p>month and day</p></td>
    </tr>
    <tr>
      <td><p>Year/MonthOfDay/DayOfWeek/…​</p></td>
      <td><p>classes for the important fields</p></td>
    </tr>
    <tr>
      <td><p>DateTimeFields</p></td>
      <td><p>stores a map of field-value pairs which may be invalid</p></td>
    </tr>
    <tr>
      <td><p>Calendrical</p></td>
      <td><p>access to the low-level API</p></td>
    </tr>
    <tr>
      <td><p>Period</p></td>
      <td><p>a descriptive amount of time, such as "2 months and 3 days"</p></td>
    </tr>
  </tbody>
</table>
<h3>Noncompliant code example</h3>

```java
Date now = new Date();  // Noncompliant
DateFormat df = new SimpleDateFormat("dd.MM.yyyy");
Calendar christmas  = Calendar.getInstance();  // Noncompliant
christmas.setTime(df.parse("25.12.2020"));
```
<h3>Compliant solution</h3>

```java
LocalDate now = LocalDate.now();  // gets calendar date. no time component
LocalTime now2 = LocalTime.now(); // gets current time. no date component
LocalDate christmas = LocalDate.of(2020,12,25);
```