<h2>Why is this an issue?</h2>
<p>A selector argument is a <code>boolean</code> argument that’s used to determine which of two paths to take through a method. Specifying such a
parameter may seem innocuous, particularly if it’s well named.</p>
<p>Unfortunately, the maintainers of the code calling the method won’t see the parameter name, only its value. They’ll be forced either to guess at
the meaning or to take extra time to look the method up.</p>
<p>Instead, separate methods should be written.</p>
<p>This rule finds methods with a <code>boolean</code> that’s used to determine which path to take through the method.</p>
<h3>Noncompliant code example</h3>

```java
public String tempt(String name, boolean ofAge) {
  if (ofAge) {
    offerLiquor(name);
  } else {
    offerCandy(name);
  }
}

// ...
public void corrupt() {
  tempt("Joe", false); // does this mean not to temp Joe?
}
```
<h3>Compliant solution</h3>

```java
public void temptAdult(String name) {
  offerLiquor(name);
}

public void temptChild(String name) {
    offerCandy(name);
}

// ...
public void corrupt() {
  age < legalAge ? temptChild("Joe") : temptAdult("Joe");
}
```