<h2>Why is this an issue?</h2>
<p>Use of <code>File.deleteOnExit()</code> is not recommended for the following reasons:</p>
<ul>
  <li> The deletion occurs only in the case of a normal JVM shutdown but not when the JVM crashes or is killed. </li>
  <li> For each file handler, the memory associated with the handler is released only at the end of the process. </li>
</ul>
<h3>Noncompliant code example</h3>

```java
File file = new File("file.txt");
file.deleteOnExit();  // Noncompliant
```