<h2>Why is this an issue?</h2>
<p>Callers of a <code>Boolean</code> method may be expecting to receive <code>true</code> or <code>false</code> in response. But <code>Boolean</code>
objects can take <code>null</code> as a possible value. <code>Boolean</code> methods should not return <code>null</code> unless the code is annotated
appropriately. With the proper annotation, the caller is aware that the returned value could be null.</p>
<h3>Noncompliant code example</h3>

```java
public Boolean isUsable() {
  // ...
  return null;  // Noncompliant
}

public void caller() {
  if (isUsable()) { // A NullPointerException might occur here
    // ...
  }
}
```
<h3>Compliant solution</h3>

```java
@javax.annotation.Nullable
public Boolean isUsable() {
  // ...
  return null;
}

@javax.annotation.CheckForNull
public Boolean isUsable() {
  // ...
  return null;
}

public void caller() {
  if (Boolean.True.equals(isUsable())) { // This caller knows to check and avoid ambiguity
    // ...
  }
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/476">CWE-476 - NULL Pointer Dereference</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/aDdGBQ">CERT, EXP01-J.</a> - Do not use a null in a case where an object is required </li>
</ul>