<h2>Why is this an issue?</h2>
<p>In Java 14 there is a new way to write cases in Switch Statement and Expression when the same action should be performed for different cases.
Instead of declaring multiples branches with the same action, you can combine all of them in a single case group, separated with commas. It will
result in a more concise code and improved readability.</p>
<p>This rule reports an issue when multiple cases in a Switch can be grouped into a single comma-separated case.</p>
<h3>Noncompliant code example</h3>

```java
// Switch Expression
int i = switch (mode) {
  case "a":
  case "b":
    yield 1;
  default:
    yield 3;
};

// Switch Statement
switch (mode) {
  case "a":
  case "b":
    doSomething();
    break;
  default:
    doSomethingElse();
}
```
<h3>Compliant solution</h3>

```java
// Switch Expression
int i = switch (mode) {
  case "a", "b":
    yield 1;
  default:
    yield 3;
};

// Switch Statement
switch (mode) {
  case "a", "b":
    doSomething();
    break;
  default:
    doSomethingElse();
}

// Or even better:
switch (mode) {
  case "a", "b" -> doSomething();
  default -> doSomethingElse();
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://openjdk.java.net/jeps/361">JEP 361: Switch Expressions</a> </li>
</ul>