<h2>Why is this an issue?</h2>
<p>In a Zen-like manner, <code>NaN</code> isn’t equal to anything, even itself. So comparisons (<code>&gt;, &lt;, &gt;=, &lt;=</code>) where one
operand is <code>NaN</code> or evaluates to <code>NaN</code> always return <code>false</code>. Specifically, <code>undefined</code> and objects that
cannot be converted to numbers evaluate to <code>NaN</code> when used in numerical comparisons.</p>
<p>This rule raises an issue when there is at least one path through the code where one of the operands to a comparison is <code>NaN</code>,
<code>undefined</code> or an <code>Object</code> which cannot be converted to a number.</p>
<h3>Noncompliant code example</h3>

```js
var x;  // x is currently "undefined"
if (someCondition()) {
  x = 42;
}

if (42 > x) {  // Noncompliant; "x" might still be "undefined"
  doSomething();
}

var obj = {prop: 42};
if (obj > 24) { // Noncompliant
  doSomething();
}
```
<h3>Compliant solution</h3>

```js
var x;
if (someCondition()) {
  x = 42;
} else {
  x = foo();
}

if (42 > x) {
  doSomething();
}

var obj = {prop: 42};
if (obj.prop > 24) {
  doSomething();
}
```