<h2>Why is this an issue?</h2>
<p>Expressions with arithmetic (<code>/, *, %, ++, --, -, -=, *=, /=, %=, +=, +</code>), unary (<code>-</code>), or comparison operators (<code>&gt;,
&lt;, &gt;=, &lt;=</code>) where one, or both, of the operands is a String, Boolean or Date value rely on implicit conversions. Both the
maintainability and reliability levels of such a piece of code are questionable.</p>
<h3>Noncompliant code example</h3>

```js
str = "80";
quarter = str / 4; // Noncompliant

if (str < 10) { // Noncompliant
   // ...
}
```
<h3>Compliant solution</h3>

```js
str = "80";
parsedStr = parseInt(str);
quarter = parsedStr / 4;

if (parsedStr < 10) {
  // ...
}
```
<h3>Exceptions</h3>
<ul>
  <li> Expressions using the binary <code>+</code> operator with at least one <code>String</code> operand are ignored because the <code>+</code>
  operator will perform a concatenation in that case. </li>
  <li> Comparisons where both operands are strings are ignored because a lexicographical comparison is performed in that case. </li>
</ul>