<h2>Why is this an issue?</h2>
<p>ARIA (Accessible Rich Internet Applications) attributes are used to enhance the accessibility of web content and web applications. These attributes
provide additional information about an element’s role, state, properties, and values to assistive technologies like screen readers.</p>
<p>This rule checks that ARIA roles or <code>aria-*</code> attributes are not used in unsupported DOM elements, which are mostly invisible such as
<code>meta</code>, <code>html</code> or <code>head</code>.</p>
<h2>How to fix it</h2>
<p>Check if you are using ARIA roles or <code>aria-*</code> attributes in unsupported DOM elements.</p>

```js
<title aria-hidden="false">My beautiful web page</title>
```
<p>To fix the code, remove the extra ARIA role or <code>aria-*</code> attributes from the unsupported DOM elements.</p>

```js
<title>My beautiful web page</title>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Techniques">Using ARIA: Roles, states, and
  properties</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles">ARIA roles (Reference)</a> </li>
</ul>
<h3>Standards</h3>
<ul>
  <li> W3C - <a href="https://www.w3.org/TR/wai-aria-1.2/">Accessible Rich Internet Applications (WAI-ARIA) 1.2</a> </li>
</ul>