<h2>Why is this an issue?</h2>
<p>The ability to define default values for method arguments can make a method easier to use. Default argument values allow callers to specify as many
or as few arguments as they want while getting the same functionality and minimizing boilerplate, wrapper code.</p>
<p>But all method arguments with default values should be declared after the method arguments without default values. Otherwise, it makes it
impossible for callers to take advantage of defaults; they must re-specify the defaulted values in order to "get to" the non-default arguments.</p>
<h3>Noncompliant code example</h3>

```php
function makeyogurt($type = "acidophilus", $flavor){...}  // Noncompliant

makeyogurt("raspberry")}}  // Runtime error: Missing argument 2 in call to makeyogurt()
```
<h3>Compliant solution</h3>

```php
function makeyogurt($flavor, $type = "acidophilus", ){...}

makeyogurt("raspberry")}} // Works as expected
```