<h2>Why is this an issue?</h2>
<p>There’s no reason to repeat a default type unless it is early in a list and other, non-default types come after it. Instead, leave it out and only
supply type when it is something other than the default.</p>
<h3>Noncompliant code example</h3>

```ts
function foo<N = number, S = string>() {}
foo<number, string>();  // Noncompliant; both types redundant
foo<string, string>();  // Noncompliant; 2nd string is redundant
foo<number, number>();  // Ignored; number is redundant but required
```
<h3>Compliant solution</h3>

```ts
function foo<N = number, S = string>() {}
foo();
foo<string>();
foo<number, number>();
```