<h2>Why is this an issue?</h2>
<p>A regex should never include a repetitive pattern whose body would match the empty string. This is usually a sign that a part of the regex is
redundant or does not do what the author intended.</p>
<h3>Noncompliant code example</h3>

```ts
/(?:)*/      // same as the empty regex, the '*' accomplishes nothing
/(?:|x)*/    // same as the empty regex, the alternative has no effect
/(?:x|)*/    // same as 'x*', the empty alternative has no effect
/(?:x*|y*)*/ // same as 'x*', the first alternative would always match, y* is never tried
/(?:x?)*/    // same as 'x*'
/(?:x?)+/    // same as 'x*'
```
<h3>Compliant solution</h3>

```ts
/x*/
```