<h2>Why is this an issue?</h2>
<p>Entries in the ASCII table below code 32 are known as control characters or non-printing characters. As they are not common in JavaScript strings,
using these invisible characters in regular expressions is most likely a mistake.</p>

```ts
const pattern1 = /\x1a/;             // Noncompliant: 1a (23 base 10) is less than 32
const pattern2 = new RegExp('\x1a'); // Noncompliant: 1a (23 base 10) is less than 32
```
<p>Instead, one should only match printable characters in regular expressions.</p>

```ts
const pattern1 = /\x20/;
const pattern2 = new RegExp('\x20');
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/ASCII">ASCII</a> </li>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/C0_and_C1_control_codes#C0_controls">C0 and C1 control codes</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_expressions/Character_classes">Character
  classes</a> </li>
</ul>