<p>When calling <code>toString()</code> or coercing into a string an object that doesn’t implement its own <code>toString</code> method, it returns
<code>[object Object]</code> which is often not what was intended.</p>
<h2>Why is this an issue?</h2>
<p>When using an object in a string context, a developer wants to get the string representation of the state of an object, so obtaining <code>[object
Object]</code> is probably not the intended behaviour and might even denote a bug.</p>
<h2>How to fix it</h2>
<p>You can simply define a <code>toString()</code> method for the object or class.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
class Foo {};
const foo = new Foo();

foo + ''; // Noncompliant - evaluates to "[object Object]"
`Foo: ${foo}`; // Noncompliant - evaluates to "Foo: [object Object]"
foo.toString(); // Noncompliant - evaluates to "[object Object]"
```
<h4>Compliant solution</h4>

```ts
class Foo {
  toString() {
    return 'Foo';
  }
}
const foo = new Foo();

foo + '';
`Foo: ${foo}`;
foo.toString();
```
<h4>Noncompliant code example</h4>

```ts
const foo = {};
foo + ''; // Noncompliant - evaluates to "[object Object]"
`Foo: ${foo}`; // Noncompliant - evaluates to "Foo: [object Object]"
foo.toString(); // Noncompliant - evaluates to "[object Object]"
```
<h4>Compliant solution</h4>

```ts
const foo = {
  toString: () => {
    return 'Foo';
  }
}
foo + '';
`Foo: ${foo}`;
foo.toString();
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/toString"><code>Object.prototype.toString()</code></a>
  </li>
</ul>