# Prefer Zero Over Explicit Init

Prefer `.zero` over explicit init with zero parameters (e.g. `CGPoint(x: 0, y: 0)`)

* **Identifier:** prefer_zero_over_explicit_init
* **Supports autocorrection:** Yes
* **Kind:** idiomatic
* **Analyzer rule:** No
* **Minimum Swift compiler version:** 3.0.0
* **Default configuration:** warning

## Non Triggering Examples

```swift
CGRect(x: 0, y: 0, width: 0, height: 1)
```

```swift
CGPoint(x: 0, y: -1)
```

```swift
CGSize(width: 2, height: 4)
```

```swift
CGVector(dx: -5, dy: 0)
```

## Triggering Examples

```swift
↓CGPoint(x: 0, y: 0)
```

```swift
↓CGPoint(x: 0.000000, y: 0)
```

```swift
↓CGPoint(x: 0.000000, y: 0.000)
```

```swift
↓CGRect(x: 0, y: 0, width: 0, height: 0)
```

```swift
↓CGSize(width: 0, height: 0)
```

```swift
↓CGVector(dx: 0, dy: 0)
```