/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.client.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.bozaro.gitlfs.client.internal.LfsRequest;
import ru.bozaro.gitlfs.client.internal.Request;
import ru.bozaro.gitlfs.client.io.StreamProvider;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lru/bozaro/gitlfs/client/internal/ObjectPut;", "Lru/bozaro/gitlfs/client/internal/Request;", "Ljava/lang/Void;", "streamProvider", "Lru/bozaro/gitlfs/client/io/StreamProvider;", "size", "", "(Lru/bozaro/gitlfs/client/io/StreamProvider;J)V", "createRequest", "Lru/bozaro/gitlfs/client/internal/LfsRequest;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "url", "", "processResponse", "response", "Lorg/apache/http/HttpResponse;", "statusCodes", "", "gitlfs-client"})
public final class ObjectPut
implements Request<Void> {
    @NotNull
    private final StreamProvider streamProvider;
    private final long size;

    public ObjectPut(@NotNull StreamProvider streamProvider, long size) {
        Intrinsics.checkNotNullParameter((Object)streamProvider, (String)"streamProvider");
        this.streamProvider = streamProvider;
        this.size = size;
    }

    @Override
    @NotNull
    public LfsRequest createRequest(@NotNull ObjectMapper mapper, @NotNull String url) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpPut req = new HttpPut(url);
        AbstractHttpEntity entity = (AbstractHttpEntity)new InputStreamEntity(this.streamProvider.getStream(), this.size);
        entity.setContentType("application/octet-stream");
        req.setEntity((HttpEntity)entity);
        return new LfsRequest((HttpUriRequest)req, entity);
    }

    @Override
    @Nullable
    public Void processResponse(@NotNull ObjectMapper mapper, @NotNull HttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return null;
    }

    @Override
    @NotNull
    public int[] statusCodes() {
        int[] nArray = new int[]{200, 201};
        return nArray;
    }
}

