/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.abap.checks;

import eu.cqse.check.framework.core.CheckException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.abap.checks.EAbapNamingTarget;

class AbapObjectNamingRule {
    static final String PACKAGE_MACRO = "%{PACKAGE}";
    private final Pattern packagePattern;
    private final String objectRegEx;
    private final Pattern globalObjectPattern;
    private final EAbapNamingTarget objectType;

    public AbapObjectNamingRule(String packageRegEx, String objectRegEx, EAbapNamingTarget objectType) throws CheckException {
        this.packagePattern = AbapObjectNamingRule.compileAndWrap(packageRegEx);
        this.objectRegEx = objectRegEx;
        this.objectType = objectType;
        this.globalObjectPattern = !this.objectRegEx.contains(PACKAGE_MACRO) ? AbapObjectNamingRule.compileAndWrap(objectRegEx) : null;
    }

    public boolean appliesTo(ParsedAbapElementPath path, boolean useFunctionName) {
        EAbapObjectType type = path.getElementName().getObjectType();
        boolean typeMatch = useFunctionName ? this.objectType == EAbapNamingTarget.FUMO && type == EAbapObjectType.FUGR : this.objectType == EAbapNamingTarget.ALL || EAbapNamingTarget.valueOf(type.name()).equals((Object)this.objectType);
        return typeMatch && this.packagePattern.matcher(path.getPackageName()).matches();
    }

    public Pattern patternForPackage(String packageName) throws CheckException {
        if (this.globalObjectPattern != null) {
            return this.globalObjectPattern;
        }
        String objectPatternString = this.objectRegEx.replace(PACKAGE_MACRO, AbapUtils.normalizePackage(packageName));
        return AbapObjectNamingRule.compileAndWrap(objectPatternString);
    }

    private static Pattern compileAndWrap(String pattern) throws CheckException {
        try {
            return Pattern.compile(pattern, 2);
        }
        catch (PatternSyntaxException e) {
            throw new CheckException((Exception)e);
        }
    }
}

