/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.abap.codeinspector;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.abap.codeinspector.ECodeInspectorCategory;
import org.conqat.lib.commons.string.StringUtils;

public enum ECodeInspectorTestType {
    CL_CI_TEST_ABAP_NAMING("Naming Conventions", ECodeInspectorCategory.CONVENTIONS, 4, new String[0]),
    CL_CI_TEST_ABAP_NAMING_NEW("Extended Naming Conventions for Programs", ECodeInspectorCategory.CONVENTIONS, 4, new String[0]),
    CL_CI_TEST_APPEND_TO_SORTED("Search for APPEND and INSERT ... INDEX in SORTED Tables", ECodeInspectorCategory.ROBUST, 4, "SYNERR"),
    CL_CI_TEST_COMPLEX_WHERE("Complex WHERE Condition in SELECT Statement", ECodeInspectorCategory.ROBUST, 2, new String[0]),
    CL_CI_TEST_CRITICAL_STATEMENTS("Critical Statements", ECodeInspectorCategory.SECURITY, 4, new String[0]),
    CL_CI_TEST_EXTENDED_CHECK("Extended Program Check", ECodeInspectorCategory.SYNTAX, 5, "0000", "1305"),
    CL_CI_TEST_EXTENDED_CHECK_BASE("Extended Program Check", ECodeInspectorCategory.SYNTAX, 5, "0000", "1305"),
    CL_CI_TEST_FIND_DYN_SQL("Use of ADBC Interface", ECodeInspectorCategory.SECURITY, 0, "_SYNERR_"),
    CL_CI_TEST_FOR_ALL_ENTRIES("Unsecure use of FOR ALL ENTRIES", ECodeInspectorCategory.ROBUST, 0, new String[0]),
    CL_CI_TEST_IMUD_NESTED("Changing Database Accesses in Loops", ECodeInspectorCategory.PERFORMANCE, 2, new String[0]),
    CL_CI_TEST_IMUD_TAW_A("Analysis of WHERE Condition in Update and DELETE", ECodeInspectorCategory.PERFORMANCE, 5, new String[0]),
    CL_CI_TEST_IMUD_TAW_SEC01("Dynamic and Client-Specified Accesses with INSERT, UPDATE, MODIFY, DELETE", ECodeInspectorCategory.SECURITY, 4, new String[0]),
    CL_CI_TEST_ITAB_PERFORMANCE("Low Performance Operations on Internal Tables", ECodeInspectorCategory.PERFORMANCE, 5, new String[0]),
    CL_CI_TEST_METRIC_LANGU_COMM("Comment Language Metrics", ECodeInspectorCategory.METRICS, 3, new String[0]),
    CL_CI_TEST_METRIC_PROC("Procedural Metrics", ECodeInspectorCategory.METRICS, 3, new String[0]),
    CL_CI_TEST_NO_ORDER_BY("Search problematic statements for result of SELECT/OPEN CURSOR without ORDER BY", ECodeInspectorCategory.ROBUST, 0, new String[0]),
    CL_CI_TEST_SCAN("Scanning of a Program (implicit check)", ECodeInspectorCategory.UNDEFINED, 0, new String[0]),
    CL_CI_TEST_SEARCH_UNWANTED("Find Unwanted Language Elements", ECodeInspectorCategory.SEARCH, 3, new String[0]),
    CL_CI_TEST_SELECT_EXIT("EXIT or no statement in SELECT...ENDSELECT loop", ECodeInspectorCategory.PERFORMANCE, 2, new String[0]),
    CL_CI_TEST_SELECT_NESTED("SELECTs in Loops", ECodeInspectorCategory.PERFORMANCE, 2, new String[0]),
    CL_CI_TEST_SELECT_TAW_A("Analysis of WHERE condition for SELECT", ECodeInspectorCategory.PERFORMANCE, 5, new String[0]),
    CL_CI_TEST_SELECT_TAW_BYBUF("SELECT statements that bypass the table buffer", ECodeInspectorCategory.PERFORMANCE, 5, new String[0]),
    CL_CI_TEST_SELECT_TAW_SEC01("Dynamic and Client-Specified Accesses in SELECT", ECodeInspectorCategory.SECURITY, 4, new String[0]),
    CL_CI_TEST_SORT_IN_LOOP("SORT Statement Inside a Loop", ECodeInspectorCategory.PERFORMANCE, 0, new String[0]),
    CL_CI_TEST_SYNTAX_CHECK("Syntax check", ECodeInspectorCategory.SYNTAX, 5, "1INC", "MESSAGEG46", "MESSAGEG--"),
    CL_CI_TEST_SYSUBRC("Check of SY-SUBRC Handling", ECodeInspectorCategory.ROBUST, 4, new String[0]),
    CL_CI_TEST_VALUE_PARAMETER("Low-perform. Parameter Transfer", ECodeInspectorCategory.PERFORMANCE, 4, new String[0]),
    UNKNOWN_TEST("Unkown test type.", ECodeInspectorCategory.UNDEFINED, 0, new String[0]);

    private static final int UNDEFIEND_RATING = 0;
    public final ECodeInspectorCategory category;
    private final int relevance;
    private final Set<String> noLineInfoMessageCodes;

    private ECodeInspectorTestType(String longName, ECodeInspectorCategory category, int relevance, String ... noLineInfoMessageCodes) {
        this.category = category;
        this.relevance = relevance;
        this.noLineInfoMessageCodes = new HashSet<String>(Arrays.asList(noLineInfoMessageCodes));
    }

    public String getStars() {
        return StringUtils.fillString((int)this.relevance, (char)'*');
    }

    public boolean isLineIssue(String messageCode) {
        return !this.noLineInfoMessageCodes.contains(messageCode);
    }

    public static ECodeInspectorTestType valueOfOrUnkown(String testTypeName) {
        try {
            return ECodeInspectorTestType.valueOf(testTypeName);
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN_TEST;
        }
    }

    public boolean isExtendedCheck() {
        return this == CL_CI_TEST_EXTENDED_CHECK || this == CL_CI_TEST_EXTENDED_CHECK_BASE;
    }
}

