/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CaseInsensitiveStringSet
implements Set<String> {
    private Map<String, String> caseInsensitiveMapping = new HashMap<String, String>();

    public CaseInsensitiveStringSet() {
    }

    public CaseInsensitiveStringSet(Collection<String> strings) {
        this.addAll((Collection<? extends String>)strings);
    }

    public String get(String string) {
        return this.caseInsensitiveMapping.get(CaseInsensitiveStringSet.getMappingKey(string));
    }

    private static String getMappingKey(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    @Override
    public int size() {
        return this.caseInsensitiveMapping.size();
    }

    @Override
    public boolean isEmpty() {
        return this.caseInsensitiveMapping.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof String) {
            String mappingKey = CaseInsensitiveStringSet.getMappingKey((String)o);
            return this.caseInsensitiveMapping.containsKey(mappingKey);
        }
        return false;
    }

    @Override
    public Iterator<String> iterator() {
        return this.caseInsensitiveMapping.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.caseInsensitiveMapping.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.caseInsensitiveMapping.values().toArray(a);
    }

    @Override
    public boolean add(String e) {
        if (!this.contains(e)) {
            this.caseInsensitiveMapping.put(CaseInsensitiveStringSet.getMappingKey(e), e);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof String) {
            return this.caseInsensitiveMapping.remove(CaseInsensitiveStringSet.getMappingKey((String)o)) != null;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        boolean setChanged = false;
        for (String string : c) {
            setChanged |= this.add(string);
        }
        return setChanged;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean setChanged = false;
        CaseInsensitiveStringSet retain = new CaseInsensitiveStringSet();
        for (Object toRetain : c) {
            if (!(toRetain instanceof String)) continue;
            retain.add((String)toRetain);
        }
        ArrayList<String> keys = new ArrayList<String>(this.caseInsensitiveMapping.keySet());
        for (String string : keys) {
            if (retain.contains(string)) continue;
            setChanged |= this.remove(string);
        }
        return setChanged;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean setChanged = false;
        for (Object o : c) {
            setChanged |= this.remove(o);
        }
        return setChanged;
    }

    @Override
    public void clear() {
        this.caseInsensitiveMapping.clear();
    }

    public String toString() {
        return this.caseInsensitiveMapping.values().toString();
    }
}

