/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.compare;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.BinaryOperator;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ComparableUtils {
    private ComparableUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    private static <T> T max(Comparator<? super T> comparator, T first, T second) {
        return comparator.compare(first, second) >= 0 ? first : second;
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> T max(T first, T second, T ... further) {
        return (T)((Comparable)ComparableUtils.max(Comparator.naturalOrder(), first, second, further));
    }

    @SafeVarargs
    public static <T> T max(Comparator<? super T> comparator, T first, T second, T ... further) {
        T max = ComparableUtils.max(comparator, first, second);
        for (T item : further) {
            max = ComparableUtils.max(comparator, max, item);
        }
        return max;
    }

    public static <T> BinaryOperator<T> maxBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator");
        return (first, second) -> ComparableUtils.max(comparator, first, second);
    }

    private static <T> T min(Comparator<? super T> comparator, T first, T second) {
        return comparator.compare(first, second) <= 0 ? first : second;
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> T min(T first, T second, T ... further) {
        return (T)((Comparable)ComparableUtils.min(Comparator.naturalOrder(), first, second, further));
    }

    @SafeVarargs
    public static <T> T min(Comparator<? super T> comparator, T first, T second, T ... further) {
        T min = ComparableUtils.min(comparator, first, second);
        for (T item : further) {
            min = ComparableUtils.min(comparator, min, item);
        }
        return min;
    }

    public static <T> BinaryOperator<T> minBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator");
        return (first, second) -> ComparableUtils.min(comparator, first, second);
    }
}

