/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.diff;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.diff.DifferBase;
import org.conqat.lib.commons.diff.TextChunk;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class RegionDiffer
extends DifferBase<String> {
    private static final Pattern REGION_PATTERN = Pattern.compile("(\\d+)-(\\d+):(\\d+)-(\\d+)");
    private final Region leftRegion;
    private final Region rightRegion;

    public RegionDiffer(String regionDescription) throws IllegalArgumentException {
        Matcher matcher = REGION_PATTERN.matcher(regionDescription);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid region description: " + regionDescription);
        }
        try {
            this.leftRegion = new Region(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
            this.rightRegion = new Region(Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid region description: " + regionDescription);
        }
    }

    @Override
    protected String getElementText(String element) {
        return element;
    }

    @Override
    protected String getDiffName() {
        return "region-based";
    }

    @Override
    protected List<TextChunk> getChunks(String elementText, boolean isLeft) {
        Region region = this.leftRegion;
        if (!isLeft) {
            region = this.rightRegion;
        }
        LineOffsetConverter converter = new LineOffsetConverter(elementText);
        ArrayList<TextChunk> result = new ArrayList<TextChunk>();
        result.add(new TextChunk(0, converter.getOffset(region.getStart()), 1, region.getStart(), "pre"));
        result.add(new TextChunk(converter.getOffset(region.getStart()), converter.getOffset(region.getEnd() + 1), region.getStart(), region.getEnd() + 1, "content" + isLeft));
        result.add(new TextChunk(converter.getOffset(region.getEnd() + 1), elementText.length(), region.getEnd() + 1, converter.getLine(elementText.length()) + 1, "post"));
        return result;
    }
}

