/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.io.ByteArrayUtils;

public enum EByteOrderMark {
    UTF_32BE(Charset.forName("UTF-32BE"), new byte[]{0, 0, -2, -1}),
    UTF_32LE(Charset.forName("UTF-32LE"), new byte[]{-1, -2, 0, 0}),
    UTF_16BE(StandardCharsets.UTF_16BE, new byte[]{-2, -1}),
    UTF_16LE(StandardCharsets.UTF_16LE, new byte[]{-1, -2}),
    UTF_8_BOM(StandardCharsets.UTF_8, new byte[]{-17, -69, -65});

    public static final int MAX_BOM_LENGTH = 4;
    private final Charset encoding;
    private final byte[] bom;

    private EByteOrderMark(Charset encoding, byte[] bom) {
        this.encoding = encoding;
        CCSMAssert.isTrue(bom.length <= 4, "Inconsistent max BOM length!");
        this.bom = bom;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public byte[] getBOM() {
        return Arrays.copyOf(this.bom, this.bom.length);
    }

    public int getBOMLength() {
        return this.bom.length;
    }

    public static Optional<EByteOrderMark> determineBOM(byte[] data) {
        for (EByteOrderMark bom : EByteOrderMark.values()) {
            if (!ByteArrayUtils.isPrefix(bom.bom, data)) continue;
            return Optional.of(bom);
        }
        return Optional.empty();
    }

    public static Optional<EByteOrderMark> skipBOM(InputStream data) throws IOException {
        if (!data.markSupported()) {
            throw new IllegalArgumentException("InputStream must support mark");
        }
        data.mark(4);
        byte[] buffer = new byte[4];
        int readBytes = data.read(buffer);
        for (EByteOrderMark bom : EByteOrderMark.values()) {
            if (readBytes < bom.getBOMLength() || !ByteArrayUtils.isPrefix(bom.bom, buffer)) continue;
            data.reset();
            data.skip(bom.getBOMLength());
            return Optional.of(bom);
        }
        data.reset();
        return Optional.empty();
    }
}

