/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.jspecify.annotations.NonNull;

public class NonThrowingFileVisitor<T>
extends SimpleFileVisitor<T> {
    private final PairList<T, IOException> failedFiles = new PairList();
    private final ConsumerWithException<T, IOException> fileConsumer;

    public NonThrowingFileVisitor(@NonNull ConsumerWithException<T, IOException> fileConsumer) {
        CCSMAssert.isNotNull(fileConsumer, () -> String.format("Expected \"%s\" to be not null", "fileConsumer"));
        this.fileConsumer = fileConsumer;
    }

    @Override
    public FileVisitResult visitFile(T file, BasicFileAttributes attrs) {
        try {
            this.fileConsumer.accept(file);
        }
        catch (IOException e) {
            this.handleIoException(file, e);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(T file, IOException exc) {
        this.handleIoException(file, exc);
        return FileVisitResult.CONTINUE;
    }

    private void handleIoException(T file, IOException exception) {
        this.failedFiles.add((IOException)file, exception);
    }

    public PairList<T, IOException> getFailedFiles() {
        return this.failedFiles;
    }
}

