/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;

public class FilteredObjectStreams {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EDiscouragedPackageBehavior SHOULD_LOG_DISCOURAGED_PACKAGES = FilteredObjectStreams.getDiscouragedPackageBehavior();
    private static final UnmodifiableSet<String> DISCOURAGED_PACKAGES = FilteredObjectStreams.getDiscouragedPackages();
    private static final UnmodifiableSet<String> ALLOWED_PACKAGES = FilteredObjectStreams.getAllowedPackages();
    private static final UnmodifiableSet<String> BLOCKLISTED_NAMES = FilteredObjectStreams.getBlocklistedNames();

    private static UnmodifiableSet<String> getAllowedPackages() {
        Set<String> defaultPackages = Set.of("java", "org.conqat", "com.teamscale", "eu.cqse", "com.fasterxml.jackson.databind.node");
        List<String> customPackages = Arrays.asList(System.getProperty("com.teamscale.io.allowed-packages", "").split(","));
        return CollectionUtils.asUnmodifiable(Stream.of(defaultPackages, customPackages, FilteredObjectStreams.getDiscouragedPackages()).flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    private static UnmodifiableSet<String> getDiscouragedPackages() {
        return CollectionUtils.asUnmodifiable(Set.of("com.google.common.collect"));
    }

    private static EDiscouragedPackageBehavior getDiscouragedPackageBehavior() {
        String configuredValue = System.getProperty("com.teamscale.io.discouraged-packages", EDiscouragedPackageBehavior.FAIL_SERIALIZING.name());
        EDiscouragedPackageBehavior resolved = EnumUtils.valueOfIgnoreCase(EDiscouragedPackageBehavior.class, configuredValue);
        if (resolved == null) {
            throw new IllegalArgumentException("Could not find behavior for: %s\nValid values: %s".formatted(configuredValue, Arrays.toString((Object[])EDiscouragedPackageBehavior.values())));
        }
        return resolved;
    }

    @VisibleForTesting
    static void verifyClassIsAllowed(ObjectStreamClass desc, boolean serializing) throws InvalidClassException {
        String name = FilteredObjectStreams.getName(desc);
        if (name.isEmpty()) {
            return;
        }
        if (BLOCKLISTED_NAMES.stream().anyMatch(name::startsWith)) {
            throw new InvalidClassException("Class not supported for (de)serialization, blocklisted", desc.getName());
        }
        if (FilteredObjectStreams.packageNameIsNotAllowed(name)) {
            throw new InvalidClassException("Class not supported for (de)serialization", desc.getName());
        }
        if (FilteredObjectStreams.isDiscouragedClass(name)) {
            SHOULD_LOG_DISCOURAGED_PACKAGES.handleDiscouragedClass(name, serializing);
        }
    }

    private static boolean packageNameIsNotAllowed(String className) {
        return ALLOWED_PACKAGES.stream().noneMatch(allowedPackage -> className.startsWith(StringUtils.ensureEndsWith(allowedPackage, ".")));
    }

    private static boolean isDiscouragedClass(String name) {
        return DISCOURAGED_PACKAGES.stream().anyMatch(discouragedPackage -> name.startsWith(StringUtils.ensureEndsWith(discouragedPackage, ".")));
    }

    private static String getName(ObjectStreamClass desc) {
        String name = desc.getName();
        if (name.startsWith("[")) {
            return name.replaceFirst("\\[+.(.*);?", "$1");
        }
        return name;
    }

    public static ObjectInputStream filteredInputStream(InputStream in) throws IOException {
        return new FilteredObjectInputStream(in);
    }

    public static ObjectOutputStream filteredOutputStream(OutputStream out) throws IOException {
        return new FilteredObjectOutputStream(out);
    }

    private static UnmodifiableSet<String> getBlocklistedNames() {
        HashSet<String> blocklistedNames = new HashSet<String>(Set.of("bsh.XThis", "bsh.Interpreter", "com.mchange.v2.c3p0.impl.PoolBackedDataSourceBase", "org.apache.commons.beanutils.BeanComparator", "org.apache.commons.collections.Transformer", "org.apache.commons.collections.functors.InvokerTransformer", "org.apache.commons.collections.functors.ChainedTransformer", "org.apache.commons.collections.functors.ConstantTransformer", "org.apache.commons.collections.functors.InstantiateTransformer", "org.apache.commons.collections4.functors.InvokerTransformer", "org.apache.commons.collections4.functors.ChainedTransformer", "org.apache.commons.collections4.functors.ConstantTransformer", "org.apache.commons.collections4.functors.InstantiateTransformer", "org.apache.commons.collections4.comparators.TransformingComparator", "org.apache.commons.fileupload.disk.DiskFileItem", "org.apache.wicket.util.upload.DiskFileItem", "org.codehaus.groovy.runtime.ConvertedClosure", "org.codehaus.groovy.runtime.MethodClosure", "org.hibernate.engine.spi.TypedValue", "org.hibernate.tuple.component.AbstractComponentTuplizer", "org.hibernate.tuple.component.PojoComponentTuplizer", "org.hibernate.type.AbstractType", "org.hibernate.type.ComponentType", "org.hibernate.type.Type", "com.sun.rowset.JdbcRowSetImpl", "org.jboss.interceptor.builder.InterceptionModelBuilder", "org.jboss.interceptor.builder.MethodReference", "org.jboss.interceptor.proxy.DefaultInvocationContextFactory", "org.jboss.interceptor.proxy.InterceptorMethodHandler", "org.jboss.interceptor.reader.ClassMetadataInterceptorReference", "org.jboss.interceptor.reader.DefaultMethodMetadata", "org.jboss.interceptor.reader.ReflectiveClassMetadata", "org.jboss.interceptor.reader.SimpleInterceptorMetadata", "org.jboss.interceptor.spi.instance.InterceptorInstantiator", "org.jboss.interceptor.spi.metadata.InterceptorReference", "org.jboss.interceptor.spi.metadata.MethodMetadata", "org.jboss.interceptor.spi.model.InterceptionModel", "org.jboss.interceptor.spi.model.InterceptionType", "org.jboss.weld.interceptor.builder.InterceptionModelBuilder", "org.jboss.weld.interceptor.builder.MethodReference", "org.jboss.weld.interceptor.proxy.DefaultInvocationContextFactory", "org.jboss.weld.interceptor.proxy.InterceptorMethodHandler", "org.jboss.weld.interceptor.reader.ClassMetadataInterceptorReference", "org.jboss.weld.interceptor.reader.DefaultMethodMetadata", "org.jboss.weld.interceptor.reader.ReflectiveClassMetadata", "org.jboss.weld.interceptor.reader.SimpleInterceptorMetadata", "org.jboss.weld.interceptor.spi.instance.InterceptorInstantiator", "org.jboss.weld.interceptor.spi.metadata.InterceptorReference", "org.jboss.weld.interceptor.spi.metadata.MethodMetadata", "org.jboss.weld.interceptor.spi.model.InterceptionModel", "org.jboss.weld.interceptor.spi.model.InterceptionType", "java.rmi.registry.Registry", "java.rmi.server.ObjID", "java.rmi.server.RemoteObjectInvocationHandler", "net.sf.json.JSONObject", "javax.xml.transform.Templates", "org.python.core.PyObject", "org.python.core.PyBytecode", "org.python.core.PyFunction", "org.mozilla.javascript..*", "org.apache.myfaces.context.servlet.FacesContextImpl", "org.apache.myfaces.context.servlet.FacesContextImplBase", "org.apache.myfaces.el.CompositeELResolver", "org.apache.myfaces.el.unified.FacesELContext", "org.apache.myfaces.view.facelets.el.ValueExpressionMethodExpression", "com.sun.syndication.feed.impl.ObjectBean", "org.springframework.beans.factory.ObjectFactory", "org.springframework.core.SerializableTypeWrapper$MethodInvokeTypeProvider", "org.springframework.aop.framework.AdvisedSupport", "org.springframework.aop.target.SingletonTargetSource", "org.springframework.aop.framework.JdkDynamicAopProxy", "org.springframework.core.SerializableTypeWrapper$TypeProvider", "java.util.PriorityQueue", "java.lang.reflect.Proxy", "javax.management.MBeanServerInvocationHandler", "javax.management.openmbean.CompositeDataInvocationHandler", "java.beans.EventHandler", "java.util.Comparator", "org.reflections.Reflections"));
        blocklistedNames.removeIf(FilteredObjectStreams::packageNameIsNotAllowed);
        return CollectionUtils.asUnmodifiable(blocklistedNames);
    }

    private static enum EDiscouragedPackageBehavior {
        NONE{

            @Override
            public void handleDiscouragedClass(String name, boolean serializing) {
            }
        }
        ,
        LOG{

            @Override
            public void handleDiscouragedClass(String name, boolean serializing) {
                Level level = serializing ? Level.ERROR : Level.WARN;
                LOGGER.atLevel(level).withThrowable((Throwable)new InvalidClassException(name, "Class is discouraged")).log("Class {} is discouraged and serialization support will be removed in upcoming versions.\nPlease contact the Teamscale support if you encounter this message!", (Object)name);
            }
        }
        ,
        FAIL_SERIALIZING{

            @Override
            public void handleDiscouragedClass(String name, boolean serializing) throws InvalidClassException {
                if (serializing) {
                    throw new InvalidClassException(name, "Class is not supported for serialization");
                }
                LOG.handleDiscouragedClass(name, serializing);
            }
        }
        ,
        FAIL{

            @Override
            public void handleDiscouragedClass(String name, boolean serializing) throws InvalidClassException {
                throw new InvalidClassException(name, "Class is not supported for (de)serialization");
            }
        };


        public abstract void handleDiscouragedClass(String var1, boolean var2) throws InvalidClassException;
    }

    private static final class FilteredObjectInputStream
    extends ObjectInputStream {
        public FilteredObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            FilteredObjectStreams.verifyClassIsAllowed(desc, false);
            return this.doResolveClass(desc);
        }

        private Class<?> doResolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return super.resolveClass(desc);
            }
            catch (ClassNotFoundException e) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                if (contextClassLoader != null) {
                    try {
                        return Class.forName(desc.getName(), false, contextClassLoader);
                    }
                    catch (ClassNotFoundException e2) {
                        e.addSuppressed(e2);
                    }
                }
                throw e;
            }
        }
    }

    private static final class FilteredObjectOutputStream
    extends ObjectOutputStream {
        public FilteredObjectOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            FilteredObjectStreams.verifyClassIsAllowed(desc, true);
            super.writeClassDescriptor(desc);
        }
    }
}

