/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.markup;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.jspecify.annotations.NonNull;

public class MarkdownCodeBlockFinder {
    public static List<CodeBlockStartLine> findCodeBlockStartLines(@NonNull String fileContent) {
        ArrayList<CodeBlockStartLine> codeBlockStartLines = new ArrayList<CodeBlockStartLine>();
        Scanner sc = new Scanner(fileContent);
        int currentLineNumber = 0;
        boolean nextDelimiterIsStartOfCodeBlock = true;
        while (sc.hasNextLine()) {
            ++currentLineNumber;
            String currentLine = sc.nextLine();
            if (!currentLine.startsWith("```")) continue;
            if (nextDelimiterIsStartOfCodeBlock) {
                codeBlockStartLines.add(new CodeBlockStartLine(currentLine, currentLineNumber));
            }
            nextDelimiterIsStartOfCodeBlock = !nextDelimiterIsStartOfCodeBlock;
        }
        sc.close();
        return codeBlockStartLines;
    }

    public static class CodeBlockStartLine {
        private final String lineContent;
        private final int lineNumber;

        private CodeBlockStartLine(String lineContent, int lineNumber) {
            this.lineContent = lineContent;
            this.lineNumber = lineNumber;
        }

        public String getLineContent() {
            return this.lineContent;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

