/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.math;

import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.math.EAggregationStrategy;
import org.conqat.lib.commons.math.Range;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class MathUtils {
    public static double sum(Collection<? extends Number> collection) {
        return MathUtils.aggregate(collection, EAggregationStrategy.SUM);
    }

    public static double max(Collection<? extends Number> collection) {
        return MathUtils.aggregate(collection, EAggregationStrategy.MAX);
    }

    public static double min(Collection<? extends Number> collection) {
        return MathUtils.aggregate(collection, EAggregationStrategy.MIN);
    }

    public static double mean(Collection<? extends Number> collection) {
        return MathUtils.aggregate(collection, EAggregationStrategy.MEAN);
    }

    public static double median(Collection<? extends Number> collection) {
        return MathUtils.aggregate(collection, EAggregationStrategy.MEDIAN);
    }

    public static double percentile25(Collection<? extends Number> collection) {
        return MathUtils.aggregate(collection, EAggregationStrategy.PERCENTILE25);
    }

    public static double percentile75(Collection<? extends Number> collection) {
        return MathUtils.aggregate(collection, EAggregationStrategy.PERCENTILE75);
    }

    public static double variance(Collection<? extends Number> collection, boolean sample) {
        if (sample) {
            return MathUtils.aggregate(collection, EAggregationStrategy.SAMPLE_VARIANCE);
        }
        return MathUtils.aggregate(collection, EAggregationStrategy.POPULATION_VARIANCE);
    }

    public static double stdDev(Collection<? extends Number> collection, boolean sample) {
        if (sample) {
            return MathUtils.aggregate(collection, EAggregationStrategy.SAMPLE_STD_DEV);
        }
        return MathUtils.aggregate(collection, EAggregationStrategy.POPULATION_STD_DEV);
    }

    public static double aggregate(Collection<? extends Number> values, EAggregationStrategy aggregation) {
        return aggregation.getAggregator().aggregate(values);
    }

    public static long factorial(int n) {
        long result = 1L;
        for (int i = 2; i <= n; ++i) {
            result *= (long)i;
        }
        return result;
    }

    public static boolean isNormal(double number) {
        return !Double.isInfinite(number) && !Double.isNaN(number);
    }

    public static int choose(long n, long k) {
        CCSMAssert.isTrue(n >= 0L && k >= 0L, "Parameters must be positive.");
        if (k == 0L) {
            return 1;
        }
        if (n == 0L) {
            return 0;
        }
        return MathUtils.choose(n - 1L, k) + MathUtils.choose(n - 1L, k - 1L);
    }

    public static CounterSet<Range> rangeDistribution(List<Double> values, Set<Range> ranges) {
        CounterSet<Range> result = new CounterSet<Range>();
        for (Double value : values) {
            for (Range range : ranges) {
                if (!range.contains(value)) continue;
                result.inc(range);
            }
        }
        return result;
    }

    public static void printBasicDescriptiveStatistics(Collection<? extends Number> values) {
        MathUtils.printBasicDescriptiveStatistics(values, System.out);
    }

    public static void printBasicDescriptiveStatistics(Collection<? extends Number> values, PrintStream printStream) {
        printStream.println("Min          : " + MathUtils.min(values));
        printStream.println("Max          : " + MathUtils.max(values));
        printStream.println("Sum          : " + MathUtils.sum(values));
        printStream.println("Mean         : " + MathUtils.mean(values));
        printStream.println("Percentile25 : " + MathUtils.percentile25(values));
        printStream.println("Median       : " + MathUtils.median(values));
        printStream.println("Percentile75 : " + MathUtils.percentile75(values));
    }

    public static int constrainValue(int value, int min, int max) {
        return (int)MathUtils.constrainValue((double)value, (double)min, (double)max);
    }

    public static double constrainValue(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private MathUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

