/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.math;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.text.NumberFormat;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class Range
implements Comparable<Range>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String LOWER_PROPERTY = "lower";
    private static final String UPPER_PROPERTY = "upper";
    @JsonProperty(value="lower")
    private final double lower;
    @JsonProperty(value="upper")
    private final double upper;
    @JsonProperty(value="lowerIsInclusive")
    private final boolean lowerIsInclusive;
    @JsonProperty(value="upperIsInclusive")
    private final boolean upperIsInclusive;

    @JsonCreator
    public Range(@JsonProperty(value="lower") double lower, @JsonProperty(value="upper") double upper) {
        this(lower, true, upper, true);
    }

    public Range(double lowerBound, boolean lowerIsInclusive, double upperBound, boolean upperIsInclusive) {
        CCSMAssert.isFalse(Double.isNaN(lowerBound), "Lower bound must not be NaN");
        CCSMAssert.isFalse(Double.isNaN(upperBound), "Upper bound must not be NaN");
        this.lower = lowerBound;
        this.lowerIsInclusive = lowerIsInclusive;
        this.upper = upperBound;
        this.upperIsInclusive = upperIsInclusive;
    }

    public boolean contains(double number) {
        if (this.lowerIsInclusive ? number < this.lower : number <= this.lower) {
            return false;
        }
        if (this.upperIsInclusive) {
            return !(number > this.upper);
        }
        return !(number >= this.upper);
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int result = Range.hash(this.upper) + 37 * Range.hash(this.lower);
        if (this.lowerIsInclusive) {
            result ^= 0x100000;
        }
        if (this.upperIsInclusive) {
            result ^= 0x4000;
        }
        return result;
    }

    private static int hash(double number) {
        long bits = Double.doubleToLongBits(number);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        return this.lowerIsInclusive == other.lowerIsInclusive && this.upperIsInclusive == other.upperIsInclusive && this.lower == other.lower && this.upper == other.upper;
    }

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public boolean isLowerInclusive() {
        return this.lowerIsInclusive;
    }

    public boolean isUpperInclusive() {
        return this.upperIsInclusive;
    }

    public boolean isEmpty() {
        if (this.lowerIsInclusive && this.upperIsInclusive) {
            return this.lower > this.upper;
        }
        return this.lower >= this.upper;
    }

    public boolean isSingleton() {
        return this.lower == this.upper && this.lowerIsInclusive && this.upperIsInclusive;
    }

    public double size() {
        return Math.max(0.0, this.upper - this.lower);
    }

    public String toString() {
        return this.format(null);
    }

    public String format(NumberFormat numberFormat) {
        StringBuilder result = new StringBuilder();
        if (this.lowerIsInclusive) {
            result.append("[");
        } else {
            result.append("]");
        }
        result.append(StringUtils.format(this.lower, numberFormat) + ";" + StringUtils.format(this.upper, numberFormat));
        if (this.upperIsInclusive) {
            result.append("]");
        } else {
            result.append("[");
        }
        return result.toString();
    }

    public boolean overlaps(Range other) {
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        if (this.lower == other.lower) {
            if (this.isSingleton()) {
                return other.lowerIsInclusive;
            }
            if (other.isSingleton()) {
                return this.lowerIsInclusive;
            }
            return true;
        }
        if (this.lower < other.lower) {
            if (this.upperIsInclusive && other.lowerIsInclusive) {
                return other.lower <= this.upper;
            }
            return other.lower < this.upper;
        }
        return other.overlaps(this);
    }

    @Override
    public int compareTo(Range other) {
        int result = Double.compare(this.lower, other.lower);
        if (result != 0) {
            return result;
        }
        if (this.lowerIsInclusive && !other.lowerIsInclusive) {
            return -1;
        }
        if (!this.lowerIsInclusive && other.lowerIsInclusive) {
            return 1;
        }
        return 0;
    }

    public boolean contains(Range other) {
        boolean sameLowerBound = this.isLowerInclusive() == other.isLowerInclusive() && this.getLower() == other.getLower();
        boolean containsLower = this.contains(other.getLower()) || sameLowerBound;
        boolean sameUpperBound = this.isUpperInclusive() == other.isUpperInclusive() && this.getUpper() == other.getUpper();
        boolean containsUpper = this.contains(other.getUpper()) || sameUpperBound;
        return containsLower && containsUpper;
    }

    public Range union(Range other) {
        boolean upperInclusive;
        double maxUpper;
        boolean lowerInclusive;
        double minLower;
        double lowerBoundOfOtherRange = other.getLower();
        if (this.lower == lowerBoundOfOtherRange) {
            minLower = this.lower;
            lowerInclusive = this.isLowerInclusive() || other.isLowerInclusive();
        } else if (this.lower < lowerBoundOfOtherRange) {
            minLower = this.lower;
            lowerInclusive = this.isLowerInclusive();
        } else {
            minLower = lowerBoundOfOtherRange;
            lowerInclusive = other.isLowerInclusive();
        }
        double upperBoundOfOtherRange = other.getUpper();
        if (this.upper == upperBoundOfOtherRange) {
            maxUpper = this.upper;
            upperInclusive = this.isUpperInclusive() || other.isUpperInclusive();
        } else if (this.upper < upperBoundOfOtherRange) {
            maxUpper = upperBoundOfOtherRange;
            upperInclusive = other.isUpperInclusive();
        } else {
            maxUpper = this.upper;
            upperInclusive = this.isUpperInclusive();
        }
        return new Range(minLower, lowerInclusive, maxUpper, upperInclusive);
    }
}

