/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.math;

import java.util.Collection;
import org.conqat.lib.commons.math.IAggregator;
import org.conqat.lib.commons.math.MathUtils;

public class VarianceAggregator
implements IAggregator {
    private final boolean sample;

    public VarianceAggregator(boolean sample) {
        this.sample = sample;
    }

    @Override
    public double aggregate(Collection<? extends Number> values) {
        if (values.isEmpty()) {
            return Double.NaN;
        }
        return this.calcVariance(values, MathUtils.mean(values));
    }

    private double calcVariance(Collection<? extends Number> values, double mean) {
        if (values.size() == 1) {
            return 0.0;
        }
        double totalDeviationSquared = 0.0;
        double totalDeviation = 0.0;
        for (Number number : values) {
            double deviation = number.doubleValue() - mean;
            totalDeviationSquared += deviation * deviation;
            totalDeviation += deviation;
        }
        double x = totalDeviationSquared - totalDeviation * totalDeviation / (double)values.size();
        if (this.sample) {
            return x / (double)(values.size() - 1);
        }
        return x / (double)values.size();
    }

    @Override
    public double getNeutralElement() {
        return Double.NaN;
    }
}

