/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.objects;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedPrimitiveFieldBase;
import org.jspecify.annotations.Nullable;

public class SerializedClassValues {
    private List<Object> preFieldData = null;
    private List<Object> fieldValues = null;
    private List<Object> postFieldData = null;

    public SerializedClassValues(int size) {
        this.fieldValues = new ArrayList<Object>(Collections.nCopies(size, null));
    }

    public SerializedClassValues(SerializedClass serializedClass, DataInputStream din, SerializedEntityParser parser) throws IOException {
        if (serializedClass.isSerializable()) {
            if (serializedClass.hasWriteMethod()) {
                this.parseWithData(serializedClass, din, parser, true);
            } else {
                this.parseFieldValues(serializedClass, din, parser);
            }
        } else if (serializedClass.isExternalizable()) {
            if (!serializedClass.hasBlockData()) {
                throw new IOException("Externalizable with externalContents (old serialization protocol) not supported!");
            }
            this.parseWithData(serializedClass, din, parser, false);
        } else {
            throw new IOException("Invalid class encountered: neither serializable nor externalizable: " + serializedClass.getName());
        }
    }

    private void parseWithData(SerializedClass serializedClass, DataInputStream din, SerializedEntityParser parser, boolean mayContainFields) throws IOException {
        boolean isPreFields = true;
        block6: while (true) {
            din.mark(1);
            byte next = din.readByte();
            switch (next) {
                case 119: {
                    int shortBlockLength = din.readUnsignedByte();
                    this.readBlockData(din, shortBlockLength, isPreFields);
                    continue block6;
                }
                case 122: {
                    int longBlockLength = din.readInt();
                    this.readBlockData(din, longBlockLength, isPreFields);
                    continue block6;
                }
                case 120: {
                    return;
                }
                case 112: 
                case 113: 
                case 115: 
                case 116: 
                case 117: 
                case 124: 
                case 126: {
                    din.reset();
                    this.appendData(parser.parseContent(), isPreFields);
                    continue block6;
                }
            }
            if (!mayContainFields) {
                throw new IOException("No more fields expected at this time!");
            }
            mayContainFields = false;
            isPreFields = false;
            din.reset();
            this.parseFieldValues(serializedClass, din, parser);
        }
    }

    private void readBlockData(DataInputStream din, int length, boolean isPreFields) throws IOException {
        byte[] data = new byte[length];
        din.readFully(data);
        this.appendData(data, isPreFields);
    }

    public void appendData(Object data, boolean isPreFields) {
        if (isPreFields) {
            if (this.preFieldData == null) {
                this.preFieldData = new ArrayList<Object>();
            }
            this.preFieldData.add(data);
        } else {
            if (this.postFieldData == null) {
                this.postFieldData = new ArrayList<Object>();
            }
            this.postFieldData.add(data);
        }
    }

    private void parseFieldValues(SerializedClass serializedClass, DataInputStream din, SerializedEntityParser parser) throws IOException {
        this.fieldValues = new ArrayList<Object>();
        for (SerializedFieldBase field : serializedClass.getFields()) {
            this.fieldValues.add(field.readValue(din, parser));
        }
    }

    public int getSize() {
        if (this.fieldValues == null) {
            return 0;
        }
        return this.fieldValues.size();
    }

    public @Nullable Object getValue(int index) {
        if (index >= this.fieldValues.size()) {
            return null;
        }
        return this.fieldValues.get(index);
    }

    public void setValue(int index, Object value) {
        while (index >= this.fieldValues.size()) {
            this.fieldValues.add(null);
        }
        this.fieldValues.set(index, value);
    }

    public void removeValue(int index) {
        this.fieldValues.remove(index);
    }

    public void serialize(SerializedClass serializedClass, SerializedEntityPool pool, DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        SerializedClassValues.writeRawData(this.preFieldData, pool, serializer);
        if (this.fieldValues != null) {
            this.serializeFieldValues(serializedClass, pool, dos, serializer);
        }
        SerializedClassValues.writeRawData(this.postFieldData, pool, serializer);
        if (!serializedClass.isSerializable() || serializedClass.hasWriteMethod()) {
            dos.writeByte(120);
        }
    }

    private void serializeFieldValues(SerializedClass serializedClass, SerializedEntityPool pool, DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        Object value;
        int index = 0;
        for (SerializedFieldBase field : serializedClass.getFields()) {
            if (field instanceof SerializedPrimitiveFieldBase) {
                value = this.fieldValues.get(index);
                field.writeValue(value, pool, dos, serializer);
            }
            ++index;
        }
        index = 0;
        for (SerializedFieldBase field : serializedClass.getFields()) {
            if (!(field instanceof SerializedPrimitiveFieldBase)) {
                value = this.fieldValues.get(index);
                field.writeValue(value, pool, dos, serializer);
            }
            ++index;
        }
    }

    private static void writeRawData(List<Object> blockData, SerializedEntityPool pool, SerializedEntitySerializer serializer) throws IOException {
        if (blockData == null) {
            return;
        }
        serializer.serializeAnnotationList(blockData, pool);
    }

    public boolean hasFieldValues() {
        return this.fieldValues != null;
    }

    public List<Object> getPreFieldData() {
        return this.preFieldData;
    }

    public List<Object> getPostFieldData() {
        return this.postFieldData;
    }
}

